package h.com.serialportapi.comn;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import h.com.serialportapi.comn.message.IMessage;

/**
 * Created by hxd on 2018/10/29.
 */

public class CommPacket {

    private static String ResponseComm;//返回指令
    private static String requestComm;//请求指令
    private static List<IMessage> dataSet;


    public CommPacket newCommpaket() {
        return null;
    }


    /**
     * 通用方法
     *
     * @param requestComm 请求的参数（指令）
     * @param listener    设置的监听
     */
    public static void GeneralRequest(String requestComm, SerialReadThread.ReaderListener listener) {
        SerialReadThread.setCmd("41");
        SerialPortManager.instance().sendCommand(requestComm, listener);
    }

    /**
     * API中PICCActivity方法
     *
     * @param comm     send command data
     * @param listener request call listener
     */
    public static void PiccActivate(String comm, SerialReadThread.ActivityListener listener) {
        SerialReadThread.setCmd("22");
        SerialPortManager.instance().sendCommand(comm, listener);
    }

    /**
     * In API jar packet PICCAPDU method
     */
    public static void PiccAPDU(String apdu, SerialReadThread.ReaderListener listener) {
        if (apdu == null) {
            throw new RuntimeException("PiccAPDU method param apdu is null");
        } else {
            sendData = "";
            sendLength = "";
            sendLength = getLength(apdu);
            sendData = "5000" + sendLength + "2C" + apdu;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("2C");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }


    /**
     * In API jar folder PICCRATS method
     *
     * @param comm     请求的参数（指令）
     * @param listener 设置的监听
     */
    public static void PiccRequestATS(String comm, SerialReadThread.ReaderListener listener) {
        if (comm == null) {
            SerialReadThread.setCmd("2A");
            SerialPortManager.instance().sendCommand("5000002A7A", listener);
//            throw new RuntimeException("CommPacket API " +
//                    "param comm is null");
        } else {
            SerialReadThread.setCmd("2A");
            SerialPortManager.instance().sendCommand(requestComm, listener);
        }
    }

    /**
     * In API jar folder PICCTRANSFER method
     */
    public static void PiccTransfer(String apdu, SerialReadThread.ReaderListener listener) {
        if (apdu == null) {
            SerialPortManager.instance().sendCommand("5000072E0A000084000008FF", listener);
        } else {
            sendData = "";
            sendData = "5000072E" + apdu;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("2E");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar folder PICC_MF3_GETVERSION method
     */
    public static void DESGetDESVersion(String comm, SerialReadThread.ReaderListener listener) {
        if (comm == null) {
            SerialReadThread.setCmd("8B");
            SerialPortManager.instance().sendCommand("5000008BDB", listener);
        } else {
            SerialReadThread.setCmd("8B");
            SerialPortManager.instance().sendCommand(comm, listener);
        }
    }

    /**
     * In API jar folder PICC_MF3_GETKEYVER method
     */
    public static void DESGetKeyVersion(String comm, SerialReadThread.ReaderListener listener) {
        if (comm == null) {
            SerialReadThread.setCmd("85");
            SerialPortManager.instance().sendCommand("5000018500D4", listener);
        } else {
            SerialReadThread.setCmd("85");
            SerialPortManager.instance().sendCommand(comm, listener);
        }
    }

    /**
     * In API jar folder PICC_MF3_AUTHENTICATE method
     */
    public static void DESAuthenticate(String keyNum, String key, SerialReadThread.ReaderListener listener) {
        if (keyNum != null & key != null) {
            sendData = "";
            sendData = "50001181" + keyNum + key;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("81");
            SerialPortManager.instance().sendCommand(sendData, listener);
        } else {
            throw new RuntimeException("DESAuthenticate method param keyNum is null");
        }
    }

    /**
     * In API jar folder PICC_MF3_GETKEYSETTING method
     */
    public static void DESGetKeySetting(String comm, SerialReadThread.ReaderListener listener) {
        if (comm == null) {
            SerialReadThread.setCmd("82");
            SerialPortManager.instance().sendCommand("50000082D2", listener);
        } else {
            SerialReadThread.setCmd("82");
            SerialPortManager.instance().sendCommand(comm, listener);
        }
    }

    /**
     * In API jar folder PICC_MF3_CHANGKEYSETTING method
     */
    public static void DESChangKeySetting(String comm, SerialReadThread.ReaderListener listener) {
        if (comm == null) {
            throw new RuntimeException("DESChangKeySetting method param comm is null");
        } else {
            sendData = "";
            sendData = "50000184" + comm;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("84");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar folder PICC_MF#_CHANGEKEY method
     */
    public static void DESChangKey(String keyNum, String keySetting, String originalKey, String newKey, SerialReadThread.ReaderListener listener) {
        if (keyNum != null & keySetting != null & originalKey != null & newKey != null) {
            sendData = "";
            sendData = "50002283" + keyNum + keySetting + originalKey + newKey;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("83");
            SerialPortManager.instance().sendCommand(sendData, listener);
        } else {
            throw new RuntimeException("DESChangKey method param  is null");
        }
    }

    /**
     * In API jar folder PICCAUTHKEY method
     *
     * @param uidNum   this comm is card SN and Key
     * @param listener call the request the serial port data(String)
     * @param KeyType  meant KeyType is KEYB or KEYA so send serial port response
     */
    public static void PiccAuthKey(String uidNum, String KeyType, String blockAddr, String key, SerialReadThread.ReaderListener listener) {
        if (uidNum == null) {
            throw new RuntimeException("PiccAuthKey method param  is null");
        } else {
            sendData = "";
            if (blockAddr.length() == 1) {
                blockAddr = "0" + blockAddr;
            }
            if (KeyType.equals("KEYB")) {
                sendData = "50000C1661" + blockAddr + uidNum + key;
                sendData = sendData + getXor(sendData);
                SerialReadThread.setCmd("16");
                SerialPortManager.instance().sendCommand(sendData, listener);
            } else if (KeyType.equals("KEYA")) {
                sendData = "50000C1660" + blockAddr + uidNum + key;
                sendData = sendData + getXor(sendData);
                SerialReadThread.setCmd("16");
                SerialPortManager.instance().sendCommand(sendData, listener);
            } else {
                System.out.println("In PiccAuthKey method param KeyType is error");
            }
        }
    }

    /**
     * In API jar folder  PICC_MF0_AUTHENTICATE method
     */
    public static void PiccULAuth(String key, SerialReadThread.ReaderListener listener) {
        if (key == null) {

        } else {
            sendData = "";
            sendData = "50001031" + key;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("31");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    private static String sendData;//send data
    private static String sendLength;//send length

    /**
     * In API jar packet PICCREAD_A method
     * In MIFARE Classic module *Read Block* Button and
     * In Ultralight/C module "Read Page" Button use the same method PiccRead()
     */
    public static void PiccRead(String blockNum, SerialReadThread.ReaderListener listener) {
        if (blockNum == null) {
            throw new RuntimeException("PiccRead method param is null");
        } else {
            if (blockNum.length() == 1) {
                blockNum = "0" + blockNum;
            }
            sendData = "";
            sendData = "50000117" + blockNum;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("17");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar folder PICCWRITE_UL method
     *
     * @param addValue Page Address value
     */
    public static void PiccULWrite(String addValue, String comm, SerialReadThread.ReaderListener listener) {
        if (comm == null) {

        } else {
            sendData = "";
            sendLength = "";
            sendLength = getLength(comm);
            sendData = "5000" + sendLength + "19" + addValue + comm;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("19");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet PICCWRITE_A
     */
    public static void PiccWrite(String blockData, String add, SerialReadThread.ReaderListener listener) {

        if (blockData == null) {
            throw new RuntimeException("PiccWrite method param  is null");
        } else {
            sendData = "";
            sendLength = "";
            sendLength = getLength(String.format("%02X", Integer.valueOf(add))+blockData);
            sendData = "5000" + sendLength + "18" + String.format("%02X", Integer.valueOf(add)) + blockData;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("18");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }




    /*--------------------------------------------------------------------------------ISO15693 card module -----------------------------------------------------------------------------*/

    /**
     * In API jar packet I2_INVENTORY method
     * ISO15693 card
     */
    public static void ISO15693_Inventory(String slot, SerialReadThread.ReaderListener listener) {
        if (slot == null) {

        } else {
            sendData = "";
            sendData = "500003A1" + slot + "0000";
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("A1");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet SelectCard method
     */
    public static void ISO15693_SelectCard(String flag, String uid, SerialReadThread.ReaderListener listener) {
        if (flag == null & uid == null) {

        } else {
            sendData = "";
            sendData = "500009A6" + flag + uid;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("A6");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet StayQuiet method
     */
    public static void ISO15693_StayQuiet(String flag, String uid, SerialReadThread.ReaderListener listener) {
        if (flag == null & uid == null) {

        } else {
            sendData = "";
            sendData = "500009A2" + flag + uid;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("A2");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet I2_READ_BLOCK method
     */
    public static void ISO15693_Read_Block(String flag, String add, String uid, SerialReadThread.ReaderListener listener) {
        if (add.length() == 1) {
            add = "0" + add;
        }
        if (flag == null & add == null) {

        } else if (flag.equals("02")) {
            sendData = "";
            sendData = "500003A3" + flag + String.format("%02X", Integer.valueOf(add)) + "01";
            sendData = sendData + getXor(sendData);
        } else {
            sendData = "";
            sendData = "50000BA3" + flag + String.format("%02X", Integer.valueOf(add)) + "01" + uid;
            sendData = sendData + getXor(sendData);
        }
        SerialReadThread.setCmd("A3");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet I2_WRITE_BLOCK method
     */
    public static void ISO15693_Write_Block(String flag, String add, String uid, String writeBlock, SerialReadThread.ReaderListener listener) {
        if (uid == null & writeBlock == null) {

        } else {
            sendData = "";
            sendData = "";
            sendLength = getLength(flag + String.format("%02X", Integer.valueOf(add)) + uid + writeBlock);
            sendData = "5000" + sendLength + "A4" + flag + String.format("%02X", Integer.valueOf(add)) + "01" + uid + writeBlock;
            sendData = sendData + getXor(sendData);
            SerialReadThread.setCmd("A4");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet I2_LOCK_BLOCK method
     */
    public static void ISO15693_Lock_Block(String flag, String add, String uid, SerialReadThread.ReaderListener listener) {
        if (uid == null | flag == null | add == null) {

        } else {
            sendData = "";
            sendLength = "";
            if (flag.equals("22")) {
                sendLength = getLength(flag + String.format("%02X", Integer.valueOf(add)) + uid);
                sendData = "5000" + sendLength + "A5" + flag + String.format("%02X", Integer.valueOf(add)) + uid;
                sendData = sendData + getXor(sendData);
            } else {
                sendLength = getLength(flag + String.format("%02X", Integer.valueOf(add)));
                sendData = "5000" + sendLength + "A5" + flag + String.format("%02X", Integer.valueOf(add));
                sendData = sendData + getXor(sendData);
            }
            SerialReadThread.setCmd("A5");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet I2_WRITE_AFI method
     */
    public static void ISO15693_Write_AFI(String flag, String AFI, String uid, SerialReadThread.ReaderListener listener) {
        if (AFI == null & flag == null) {

        } else {
            sendData = "";
            sendLength = "";
            if (flag.equals("22")) {
                sendLength = getLength(flag + AFI + uid);
                sendData = "5000" + sendLength + "A8" + flag + AFI + uid;
                sendData = sendData + getXor(sendData);
            } else {
                sendLength = getLength(flag + AFI);
                sendData = "5000" + sendLength + "A8" + flag + AFI;
                sendData = sendData + getXor(sendData);
            }
            SerialReadThread.setCmd("A8");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet I2_LOCK_AFI method
     */
    public static void ISO15693_Lock_AFI(String flag, String uid, SerialReadThread.ReaderListener listener) {
        if (uid == null) {

        } else {
            sendData = "";
            sendLength = "";
            if (flag.equals("22")) {
                sendLength = getLength(flag + uid);
                sendData = "5000" + sendLength + "A9" + flag + uid;
                sendData = sendData + getXor(sendData);
            } else {
                sendLength = "01";
                sendData = "5000" + sendLength + "A9" + flag;
                sendData = sendData + getXor(sendData);
            }
            SerialReadThread.setCmd("A9");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet I2_WRITE_DSFID method
     */
    public static void ISO15693_Write_DSFID(String flag, String dsfid, String uid, SerialReadThread.ReaderListener listener) {
        if (dsfid == null | uid == null) {

        } else {
            sendData = "";
            sendLength = "";
            if (flag.equals("22")) {
                sendLength = getLength(flag + dsfid + uid);
                sendData = "5000" + sendLength + "AA" + flag + uid;
                sendData = sendData + getXor(sendData);
            } else {
                sendLength = "02";
                sendData = "5000" + sendLength + "AA" + flag + dsfid;
                sendData = sendData + getXor(sendData);
            }
            SerialReadThread.setCmd("AA");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet I2_LOCK_DSFID method
     */
    public static void ISO15693_Lock_DSFID(String flag, String uid, SerialReadThread.ReaderListener listener) {
        if (uid == null) {

        } else {
            sendData = "";
            sendLength = "";
            if (flag.equals("22")) {
                sendLength = getLength(flag + uid);
                sendData = "5000" + sendLength + "AB" + flag + uid;
                sendData = sendData + getXor(sendData);
            } else {
                sendLength = "01";
                sendData = "5000" + sendLength + "AB" + flag;
                sendData = sendData + getXor(sendData);
            }
            SerialReadThread.setCmd("AB");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }

    /**
     * In API jar packet I2_GET_SYSTEM_INFO method
     */
    public static void ISO15693_Get_SysInfor(String flag, String uid, SerialReadThread.ReaderListener listener) {
        if (uid == null) {

        } else {
            sendData = "";
            sendLength = "";
            if (flag.equals("22")) {
                sendLength = getLength(flag + uid);
                sendData = "5000" + sendLength + "AC" + flag + uid;
                sendData = sendData + getXor(sendData);
            } else {
                sendLength = "01";
                sendData = "5000" + sendLength + "AC" + flag;
                sendData = sendData + getXor(sendData);
            }
            SerialReadThread.setCmd("AC");
            SerialPortManager.instance().sendCommand(sendData, listener);
        }
    }
    /*--------------------------------------------------------------------------------ISO15693 card module -----------------------------------------------------------------------------*/


    /**
     * In API jar packet PICC_MF3_GETAPPIDS method
     */
    public static void DESGetApplication(SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000018800D9";
        SerialReadThread.setCmd("88");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_SELECTAPP method
     */
    public static void DESSelectApplication(String aid, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "50000389" + aid;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("89");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_FORMATPICC method
     */
    public static void DESFormatPicc(SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000018A00D9";
        SerialReadThread.setCmd("8A");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_DELETEAPP method
     */
    public static void DESDeleteApplication(String aid, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "50000387" + aid;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("87");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_CREATEAPP method
     */
    public static void DESCreateApplication(String aid, String keySetting, String keyNo, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "50000586" + aid + keySetting + keyNo;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("86");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_GETFILEIDS method
     */
    public static void DESGetFileIDs(SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000008CDC";
        SerialReadThread.setCmd("8C");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_GETFILESET method
     */
    public static void DESGetFileSettings(String fileId, SerialReadThread.ReaderListener listener) {
        sendData = "";
        if (fileId.length() == 1) {
            fileId = "0" + fileId;
        }
        sendData = "5000018D" + fileId;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("8D");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_DELETEFILE method
     */
    public static void DESDeleteDESFile(String fileId, SerialReadThread.ReaderListener listener) {
        sendData = "";
        if (fileId.length() == 1) {
            fileId = "0" + fileId;
        }
        sendData = "50000194" + fileId;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("94");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_CHANGEFILESET method
     */
    public static void DESChangeFileSettings(String fileId, String newComSet, String newAccessRights, SerialReadThread.ReaderListener listener) {
        sendData = "";
        if (fileId.length() == 1) {
            fileId = "0" + fileId;
        }
        if (newComSet.length() == 1) {
            newComSet = '0' + newComSet;
        }
        if (newAccessRights.length() != 4) {
            throw new RuntimeException("DESChangeFileSettings method param length error,Example EEEE");
        }
        sendData = "5000048E" + fileId + newComSet + newAccessRights;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("8E");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_CREATESTDDTFL method
     */
    public static void DESCreateStdDataFile(String fileId, String comSet, String accessRights, String fileSize, SerialReadThread.ReaderListener listener) {
        sendData = "";
        if (fileSize.length() == 6) {
            fileSize = fileSize.substring(0, 4);
        }
        sendData = "5000068F" + fileId + comSet + accessRights + fileSize;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("8F");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_READDATA method
     */
    public static void DESReadData(String fileId, String offSet, String length, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendLength = "";
        sendLength = getLength(fileId + offSet + length);
        sendData = "5000" + sendLength + "95" + fileId + offSet + length;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("95");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_WRITEDATA method
     */
    public static void DESWriteData(String fileId, String offSet, String length, String pBuf, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendLength = "";
        sendLength = getLength(fileId + offSet + length + pBuf);
        sendData = "5000" + sendLength + "96" + fileId + offSet + length + pBuf;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("96");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }


    /**
     * In API jar packet PICC_MF3_CREATEBKPDTFL method
     */
    public static void DESCreateBackupDataFile(String fileId, String comSet, String accessRights, String fileSize, SerialReadThread.ReaderListener listener) {
        sendData = "";
        if (fileSize.length() == 6) {
            fileSize = fileSize.substring(0, 4);
        }
        sendData = "50000690" + fileId + comSet + accessRights + fileSize;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("90");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_CREATEVALUEFL method
     */
    public static void DESCreateValueFile(String fileId, String comSet, String accessRight, String lowerLimit, String upperLimit, String value, String limitCredit, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendLength = "";
        sendLength = getLength(fileId + comSet + accessRight + lowerLimit + upperLimit + value + limitCredit);
        sendData = "5000" + sendLength + "91" + fileId + comSet + accessRight + lowerLimit + upperLimit + value + limitCredit;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("91");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_GETVALUE method
     */
    public static void DESGetValue(String fileId, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "50000197" + fileId;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("97");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_CREDIT and PICC_MF_DEBIT and PICC_MF3_LIMITEDCREDITmethod
     * comm 0X98 is PICC_MF3_CREDIT method
     * comm 0X99 is PICC_MF3_DEBIT method
     * comm 0X9A is PICC_MF3_LIMITEDCREDIT
     */
    public static void DESOperateValue(String comm, String fileId, String value, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendLength = "";
        sendLength = getLength(fileId + value);
        sendData = "5000" + sendLength + comm + fileId + value;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd(comm);
        SerialPortManager.instance().sendCommand(sendData, listener);
    }


    /**
     * In API jar packet PICC_MF3_COMMITTRANS and PICC_MF3_ABORTTRANS method
     * comm 0X9E is PICC_MF3_COMMITTRANS method
     * comm 0X9F is PICC_MF3_ABORTTANS method
     */
    public static void DESTransaction(String comm, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "500000" + comm;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd(comm);
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_CREATELNRRECFL method
     */
    public static void DESCreateLinearRecordFile(String fileId, String comms, String access, String fileSize, String number, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000" + getLength(fileId + comms + access + number) + "92" + fileId + comms + access + number;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("92");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_CREATECYCRECF method
     */
    public static void DESCreateCyclicRecordFile(String fileId, String comms, String access, String fileSize, String number, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000" + getLength(fileId + comms + access + number) + "93" + fileId + comms + access + number;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("93");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }


    /**
     * In API jar packet PICC_MF3_CLEARRECORDFIL method
     */
    public static void DESClearRecordFile(String fileId, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000" + getLength(fileId) + "9D" + fileId + "00";
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("9D");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_READRECORD(CMD=0x9C) method
     */
    public static void DESReadRecord(String fileId, String recordNo, String recordNumber, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000" + getLength(fileId + recordNo + recordNumber) + "9C" + fileId + recordNo + recordNumber;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("9C");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }

    /**
     * In API jar packet PICC_MF3_WRITERECORD(CMD=0x9B method
     */
    public static void DESWriteRecord(String fileId, String offSet, String comSet, SerialReadThread.ReaderListener listener) {
        sendData = "";
        sendData = "5000" + getLength(fileId + offSet + "0000" + comSet) + "9B" + fileId + offSet + getLength(comSet) + "00" + comSet;
        sendData = sendData + getXor(sendData);
        SerialReadThread.setCmd("9B");
        SerialPortManager.instance().sendCommand(sendData, listener);
    }


    /**
     * get xor(parity bit)
     */
    private static String getXor(String requestComm) {
        ArrayList<String> buff = new ArrayList<>();
        for (int i = 0; i < requestComm.length(); i = i + 2) {
            buff.add(requestComm.substring(i, i + 2));
        }
        int r = 0;
        for (String b : buff) {
            //把16进制的转换为10进制的数进行异或操作
            r = r ^ Integer.parseInt(String.valueOf(b), 16);
        }
        //得到异或的数之后在转换成16进制的
        String hex = Integer.toHexString(r & 0xFF);
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    /**
     * get send instructions length
     */
    private static String getLength(String sendData) {
        if ((sendData.length() / 2) == 0) {
            return "00";
        } else if (String.valueOf(sendData.length() / 2).length() == 1) {
            return "0" + String.valueOf((sendData.length() / 2));
        } else {
            //return String.valueOf((sendData.length() / 2) + 1);
            if (Integer.toHexString((sendData.length() / 2) + 1).length() == 1) {
                return "0" + Integer.toHexString((sendData.length() / 2)).toUpperCase();
            } else {
                return Integer.toHexString((sendData.length() / 2)).toUpperCase();
            }
        }
    }
//    private static String setXor(String comm) {
//        byte[] buff = comm.getBytes();
//        int r = 0;
//        for (byte b : buff) {
//            r = r ^ Integer.parseInt(String.valueOf(b), 16);
//        }
//        String hex = Integer.toHexString(r & 0xFF);
//        return hex;
//    }

//    public void test() {
//        PiccActivate(requestComm, new SerialReadThread.ReaderListener() {
//            @Override
//            public void transmitData(String msg) {
//
//            }
//        });
//    }

    public static void setResposneComm(String responseComm) {
        ResponseComm = responseComm;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(IMessage message) {
        // 收到时间，刷新界面
        //mLogFragment.add(message);
        dataSet.add(message);
    }

}
